/*
 * Decompiled with CFR 0.152.
 */
package mod.crend.dynamiccrosshair.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;
import mod.crend.dynamiccrosshairapi.registry.DynamicCrosshairStyles;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class ConfigUpdater
implements mod.crend.libbamboo.opt.ConfigUpdater {
    private Stream<class_1792> buildAdditionalItemList(String configString) {
        return Arrays.stream(configString.split(";")).filter(s -> !s.isBlank()).map(class_2960::method_12829).filter(Objects::nonNull).map(arg_0 -> ((class_7922)class_7923.field_41178).method_10223(arg_0));
    }

    private boolean updateAdditionalItems(JsonObject json, String name) {
        if (!json.has(name)) {
            return false;
        }
        JsonElement additionalItems = json.get(name);
        if (additionalItems.isJsonPrimitive()) {
            JsonArray items = new JsonArray();
            this.buildAdditionalItemList(additionalItems.getAsString()).forEach(item -> items.add(class_7923.field_41178.method_10221(item).toString()));
            json.remove(name);
            json.add(name, (JsonElement)items);
            return true;
        }
        return false;
    }

    private boolean updateDynamicCrosshairMode(JsonObject json) {
        JsonPrimitive dynamicCrosshairP;
        JsonElement dynamicCrosshair;
        if (!(!json.has("dynamicCrosshair") || (dynamicCrosshair = json.get("dynamicCrosshair")) instanceof JsonPrimitive && (dynamicCrosshairP = (JsonPrimitive)dynamicCrosshair).isBoolean())) {
            if (dynamicCrosshair.getAsString().equals("Disabled")) {
                json.add("dynamicCrosshair", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
            } else {
                json.add("dynamicCrosshair", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
            }
            return true;
        }
        return false;
    }

    private boolean updateColor(JsonObject json) {
        if (json.has("color")) {
            JsonObject color;
            JsonElement colorEl = json.get("color");
            if (!colorEl.isJsonObject()) {
                json.remove("color");
            }
            if ((color = colorEl.getAsJsonObject()).has("crosshairColor")) {
                boolean useCustomColor = !color.get("crosshairColor").getAsString().equals("Unchanged");
                int customColor = switch (color.get("crosshairColor").getAsString()) {
                    case "Red" -> -65536;
                    case "Yellow" -> -5592576;
                    case "Green" -> -16711936;
                    case "Cyan" -> -16733526;
                    case "Blue" -> -16776961;
                    case "Purple" -> -5635926;
                    default -> -5588020;
                };
                boolean enableBlend = !color.get("forceColor").getAsBoolean();
                JsonObject newColor = new JsonObject();
                newColor.add("overrideColor", (JsonElement)new JsonPrimitive(Boolean.valueOf(useCustomColor)));
                newColor.add("customColor", (JsonElement)new JsonPrimitive((Number)customColor));
                newColor.add("enableBlend", (JsonElement)new JsonPrimitive(Boolean.valueOf(enableBlend)));
                json.remove("color");
                json.add("color", (JsonElement)newColor);
                this.updateStyles(json);
                return true;
            }
        }
        return false;
    }

    private JsonObject updateStyle(JsonElement value) {
        JsonObject obj;
        if (value instanceof JsonObject && (obj = (JsonObject)value).has("style")) {
            class_2960 identifier = switch (obj.get("style").getAsString()) {
                case "Cross" -> DynamicCrosshairStyles.CROSS_OPEN;
                case "DiagonalCross" -> DynamicCrosshairStyles.CROSS_OPEN_DIAGONAL;
                case "Circle" -> DynamicCrosshairStyles.CIRCLE;
                case "CircleLarge" -> DynamicCrosshairStyles.CIRCLE_LARGE;
                case "Square" -> DynamicCrosshairStyles.SQUARE;
                case "Diamond" -> DynamicCrosshairStyles.DIAMOND_LARGE;
                case "Caret" -> DynamicCrosshairStyles.CARET;
                case "Dot" -> DynamicCrosshairStyles.DOT;
                case "SmallDiagonalCross" -> DynamicCrosshairStyles.CROSS_DIAGONAL_SMALL;
                case "Brackets" -> DynamicCrosshairStyles.BRACKETS;
                case "BracketsBottom" -> DynamicCrosshairStyles.BRACKETS_BOTTOM;
                case "BracketsTop" -> DynamicCrosshairStyles.BRACKETS_TOP;
                case "RoundBrackets" -> DynamicCrosshairStyles.BRACKETS_ROUND;
                case "Lines" -> DynamicCrosshairStyles.LINES;
                case "LineBottom" -> DynamicCrosshairStyles.LINE_BOTTOM;
                default -> DynamicCrosshairStyles.DEFAULT;
            };
            obj.remove("style");
            obj.add("style", (JsonElement)new JsonPrimitive(identifier.toString()));
            JsonElement jsonElement = obj.get("color");
            if (jsonElement instanceof JsonObject) {
                JsonObject color = (JsonObject)jsonElement;
                boolean useCustomColor = !color.get("crosshairColor").getAsString().equals("Unchanged");
                int customColor = switch (color.get("crosshairColor").getAsString()) {
                    case "Red" -> -65536;
                    case "Yellow" -> -5592576;
                    case "Green" -> -16711936;
                    case "Cyan" -> -16733526;
                    case "Blue" -> -16776961;
                    case "Purple" -> -5635926;
                    default -> -5588020;
                };
                boolean enableBlend = !color.get("forceColor").getAsBoolean();
                JsonObject newColor = new JsonObject();
                newColor.add("overrideColor", (JsonElement)new JsonPrimitive(Boolean.valueOf(useCustomColor)));
                newColor.add("customColor", (JsonElement)new JsonPrimitive((Number)customColor));
                newColor.add("enableBlend", (JsonElement)new JsonPrimitive(Boolean.valueOf(enableBlend)));
                obj.remove("color");
                obj.add("color", (JsonElement)newColor);
            }
            return obj;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void updateStyles(JsonObject json) {
        JsonElement jsonElement = json.get("crosshairStyle");
        if (jsonElement instanceof JsonObject) {
            JsonObject style = (JsonObject)jsonElement;
            jsonElement = json.get("crosshairModifiers");
            if (jsonElement instanceof JsonObject) {
                JsonElement newMod;
                JsonObject modifiers = (JsonObject)jsonElement;
                style.asMap().forEach((key, value) -> {
                    JsonObject newObject = this.updateStyle((JsonElement)value);
                    if (newObject != null) {
                        style.add(key, (JsonElement)newObject);
                    }
                });
                JsonElement jsonElement2 = modifiers.get("modInteractable");
                if (jsonElement2 instanceof JsonObject) {
                    JsonObject modInteractable = (JsonObject)jsonElement2;
                    newMod = this.updateStyle((JsonElement)modInteractable);
                    if (newMod != null) {
                        json.get("crosshairStyle").getAsJsonObject().add("interact", newMod);
                    }
                    modifiers.remove("modInteractable");
                }
                if ((newMod = modifiers.get("modUsableItem")) instanceof JsonObject) {
                    JsonObject modUsableItem = (JsonObject)newMod;
                    if ((newMod = this.updateStyle((JsonElement)modUsableItem)) != null) {
                        json.get("crosshairStyle").getAsJsonObject().add("useItem", newMod);
                    }
                    modifiers.remove("modUsableItem");
                }
                if ((newMod = modifiers.get("modShield")) instanceof JsonObject) {
                    JsonObject modShield = (JsonObject)newMod;
                    if ((newMod = this.updateStyle((JsonElement)modShield)) != null) {
                        json.get("crosshairStyle").getAsJsonObject().add("shield", newMod);
                    }
                    modifiers.remove("modShield");
                }
                if ((newMod = modifiers.get("modCorrectTool")) instanceof JsonObject) {
                    JsonObject modCorrectTool = (JsonObject)newMod;
                    if ((newMod = this.updateStyle((JsonElement)modCorrectTool)) != null) {
                        modifiers.remove("modCorrectTool");
                        modifiers.add("modCorrectTool", newMod);
                    }
                    modifiers.remove("modInteractable");
                }
                if (!((newMod = modifiers.get("modIncorrectTool")) instanceof JsonObject)) return;
                JsonObject modIncorrectTool = (JsonObject)newMod;
                if ((newMod = this.updateStyle((JsonElement)modIncorrectTool)) != null) {
                    modifiers.remove("modIncorrectTool");
                    modifiers.add("modIncorrectTool", newMod);
                }
                modifiers.remove("modInteractable");
                return;
            }
        }
        json.remove("crosshairStyle");
        json.remove("crosshairModifiers");
    }

    private boolean updateBlockTargeting(JsonObject json) {
        JsonPrimitive onBlock;
        JsonObject crosshairConfig;
        Object object;
        JsonElement jsonElement = json.get("crosshairConfig");
        if (jsonElement instanceof JsonObject && (object = (crosshairConfig = (JsonObject)jsonElement).get("onBlock")) instanceof JsonPrimitive && !(onBlock = (JsonPrimitive)object).isBoolean()) {
            switch (onBlock.getAsString()) {
                case "IfTargeting": {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    break;
                }
                case "IfInteractable": {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                    break;
                }
                case "Disabled": {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                    break;
                }
                default: {
                    crosshairConfig.add("onBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
                }
            }
            return true;
        }
        return false;
    }

    private boolean updateDisabledModifierStyle(JsonObject json) {
        boolean result = false;
        JsonElement jsonElement = json.get("crosshairModifiers");
        if (jsonElement instanceof JsonObject) {
            JsonObject modIncorrectTool;
            JsonObject modCorrectTool;
            JsonElement crosshairConfig;
            JsonElement jsonElement2;
            JsonElement style;
            JsonObject modInteractable;
            JsonElement jsonElement3;
            JsonObject crosshairModifiers = (JsonObject)jsonElement;
            JsonElement jsonElement4 = crosshairModifiers.get("modInteractable");
            if (jsonElement4 instanceof JsonObject && (jsonElement3 = (modInteractable = (JsonObject)jsonElement4).get("style")) instanceof JsonPrimitive && (style = (JsonPrimitive)jsonElement3).getAsString().equals("Disabled")) {
                jsonElement2 = json.get("crosshairConfig");
                if (jsonElement2 instanceof JsonObject) {
                    crosshairConfig = (JsonObject)jsonElement2;
                    crosshairConfig.add("onInteractableBlock", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                }
                result = true;
            }
            if ((style = crosshairModifiers.get("modCorrectTool")) instanceof JsonObject && (crosshairConfig = (modCorrectTool = (JsonObject)style).get("style")) instanceof JsonPrimitive && (style = (JsonPrimitive)crosshairConfig).getAsString().equals("Disabled")) {
                jsonElement2 = json.get("crosshairConfig");
                if (jsonElement2 instanceof JsonObject) {
                    crosshairConfig = (JsonObject)jsonElement2;
                    crosshairConfig.add("displayCorrectTool", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                }
                result = true;
            }
            if ((style = crosshairModifiers.get("modIncorrectTool")) instanceof JsonObject && (crosshairConfig = (modIncorrectTool = (JsonObject)style).get("style")) instanceof JsonPrimitive && (style = (JsonPrimitive)crosshairConfig).getAsString().equals("Disabled")) {
                jsonElement2 = json.get("crosshairConfig");
                if (jsonElement2 instanceof JsonObject) {
                    crosshairConfig = (JsonObject)jsonElement2;
                    crosshairConfig.add("displayCorrectTool", (JsonElement)new JsonPrimitive(Boolean.valueOf(false)));
                }
                result = true;
            }
        }
        return result;
    }

    public boolean updateConfigFile(JsonObject json) {
        boolean result = this.updateDynamicCrosshairMode(json);
        if (this.updateBlockTargeting(json)) {
            result = true;
        }
        if (this.updateDisabledModifierStyle(json)) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalTools")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalMeleeWeapons")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalRangedWeapons")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalThrowables")) {
            result = true;
        }
        if (this.updateAdditionalItems(json, "additionalUsableItems")) {
            result = true;
        }
        if (this.updateColor(json)) {
            result = true;
        }
        return result;
    }
}

